IF NOT OBJECT_ID('UFD_BUSCA_NFE_REFERENCIADA') IS NULL
	BEGIN 
		DROP FUNCTION UFD_BUSCA_NFE_REFERENCIADA
	END

GO

-- SELECT DBO.UFD_BUSCA_NFE_REFERENCIADA(1,2,159721,1)

CREATE FUNCTION [dbo].UFD_BUSCA_NFE_REFERENCIADA(	@CD_EMP		INT, 
													@CD_FILIAL	INT,
													@CD_NF		INT,
													@TP_ENT_SAI INT)
RETURNS VARCHAR(MAX) 
AS
BEGIN

	DECLARE @RETORNO VARCHAR(MAX)
	DECLARE @RS_NR_AUTORIZADOR VARCHAR(MAX)

	SET @RETORNO = ''

	DECLARE RS_NF_DEV CURSOR FOR
		SELECT 
			REF_NF_DEV.NR_AUTORIZADOR
		FROM EST_NF_ENT_DEVOLUCAO_NFE_CHAVE_REFERENCIA REF_NF_DEV
		WHERE 
			REF_NF_DEV.CD_EMP = @CD_EMP
			AND REF_NF_DEV.CD_FILIAL = @CD_FILIAL
			AND REF_NF_DEV.CD_NF = @CD_NF
			AND @TP_ENT_SAI = 0
		UNION 
		SELECT 
			REF_NF_DEV.NR_AUTORIZADOR
		FROM EST_NF_SAI_DEVOLUCAO_NFE_CHAVE_REFERENCIA REF_NF_DEV
		WHERE 
			REF_NF_DEV.CD_EMP = @CD_EMP
			AND REF_NF_DEV.CD_FILIAL = @CD_FILIAL
			AND REF_NF_DEV.CD_NF = @CD_NF
			AND @TP_ENT_SAI = 1

		--Abrindo cursor
		OPEN RS_NF_DEV
			
		--Atribuindo valores do select nas variáveis
		FETCH NEXT FROM RS_NF_DEV INTO  @RS_NR_AUTORIZADOR
											
		--Iniciando laço
		WHILE @@FETCH_STATUS = 0
			BEGIN			
				IF LEN(@RETORNO) > 0 
					SET @RETORNO = @RETORNO + ';' + @RS_NR_AUTORIZADOR
				ELSE				
					SET @RETORNO = @RS_NR_AUTORIZADOR

					--Atribuindo valores do select nas variáveis
				FETCH NEXT FROM RS_NF_DEV INTO  @RS_NR_AUTORIZADOR			
			END

		CLOSE RS_NF_DEV
		DEALLOCATE RS_NF_DEV
		
		RETURN @RETORNO

END
